/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Optional;

@Immutable
public class DoubleLiteral
extends Literal {
    private final double value;

    public DoubleLiteral(double value) {
        this(Optional.empty(), value);
    }

    public DoubleLiteral(Optional<NodeLocation> location, double value) {
        super(location);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitDoubleLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DoubleLiteral that = (DoubleLiteral)((Object)o);
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }
}

