/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class InListExpression
extends Expression {
    private final ImmutableList<Expression> values;

    public InListExpression(List<Expression> values) {
        this(Optional.empty(), values);
    }

    public InListExpression(Optional<NodeLocation> location, List<Expression> values) {
        super(location);
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values"));
        if (values.isEmpty()) {
            throw new IllegalArgumentException("IN statement requires at least one value.");
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="values is ImmutableList")
    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInListExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InListExpression that = (InListExpression)((Object)o);
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

