/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function.udaf;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.function.UdafAggregator;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.function.KsqlAggregateFunction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.streams.kstream.Merger;

public class KudafAggregator<K>
implements UdafAggregator<K> {
    private final int nonAggColumnCount;
    private final List<KsqlAggregateFunction<?, ?, ?>> aggregateFunctions;
    private final int columnCount;

    public KudafAggregator(int nonAggColumnCount, List<KsqlAggregateFunction<?, ?, ?>> functions) {
        this.nonAggColumnCount = nonAggColumnCount;
        this.aggregateFunctions = ImmutableList.copyOf((Collection)Objects.requireNonNull(functions, "functions"));
        this.columnCount = nonAggColumnCount + this.aggregateFunctions.size();
        if (this.aggregateFunctions.isEmpty()) {
            throw new IllegalArgumentException("Aggregator needs aggregate functions");
        }
        if (nonAggColumnCount < 0) {
            throw new IllegalArgumentException("negative nonAggColumnCount: " + nonAggColumnCount);
        }
    }

    public GenericRow apply(K k, GenericRow rowValue, GenericRow aggRowValue) {
        int idx;
        GenericRow result = GenericRow.fromList((List)aggRowValue.values());
        for (idx = 0; idx < this.nonAggColumnCount; ++idx) {
            result.set(idx, rowValue.get(idx));
        }
        for (idx = this.nonAggColumnCount; idx < this.columnCount; ++idx) {
            KsqlAggregateFunction<Object, Object, Object> func = this.aggregateFunctionForColumn(idx);
            Object currentValue = this.getCurrentValue(rowValue, func.getArgIndicesInValue(), arg_0 -> func.convertToInput(arg_0));
            Object currentAggregate = result.get(idx);
            Object newAggregate = func.aggregate(currentValue, currentAggregate);
            result.set(idx, newAggregate);
        }
        return result;
    }

    @Override
    public KsqlTransformer<K, GenericRow> getResultMapper() {
        return new ResultTransformer();
    }

    @Override
    public Merger<GenericKey, GenericRow> getMerger() {
        return (key, aggRowOne, aggRowTwo) -> {
            int idx;
            GenericRow output = new GenericRow(this.columnCount);
            for (idx = 0; idx < this.nonAggColumnCount; ++idx) {
                if (aggRowOne.get(idx) == null) {
                    output.append(aggRowTwo.get(idx));
                    continue;
                }
                output.append(aggRowOne.get(idx));
            }
            for (idx = this.nonAggColumnCount; idx < this.columnCount; ++idx) {
                KsqlAggregateFunction<Object, Object, Object> func = this.aggregateFunctionForColumn(idx);
                Object aggOne = aggRowOne.get(idx);
                Object aggTwo = aggRowTwo.get(idx);
                Object merged = func.getMerger().apply(key, aggOne, aggTwo);
                output.append(merged);
            }
            return output;
        };
    }

    private KsqlAggregateFunction<Object, Object, Object> aggregateFunctionForColumn(int columnIndex) {
        return this.aggregateFunctions.get(columnIndex - this.nonAggColumnCount);
    }

    private Object getCurrentValue(GenericRow row, List<Integer> indices, Function<List<Object>, Object> inputConverter) {
        return inputConverter.apply(indices.stream().map(arg_0 -> ((GenericRow)row).get(arg_0)).collect(Collectors.toList()));
    }

    private final class ResultTransformer
    implements KsqlTransformer<K, GenericRow> {
        private ResultTransformer() {
        }

        @Override
        public GenericRow transform(K readOnlyKey, GenericRow value, KsqlProcessingContext ctx) {
            int idx;
            if (value == null) {
                return null;
            }
            GenericRow output = new GenericRow(KudafAggregator.this.columnCount);
            for (idx = 0; idx < KudafAggregator.this.nonAggColumnCount; ++idx) {
                output.append(value.get(idx));
            }
            for (idx = KudafAggregator.this.nonAggColumnCount; idx < KudafAggregator.this.columnCount; ++idx) {
                KsqlAggregateFunction function = KudafAggregator.this.aggregateFunctionForColumn(idx);
                Object agg = value.get(idx);
                Object reduced = function.getResultMapper().apply(agg);
                output.append(reduced);
            }
            return output;
        }
    }
}

