/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;

public final class TermEvaluationContext {
    private final GenericRow row;
    private final Deque<Map<String, Object>> variableMappingsStack = new LinkedList<Map<String, Object>>();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TermEvaluationContext(GenericRow row) {
        this.row = row;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public GenericRow getRow() {
        return this.row;
    }

    public void pushVariableMappings(Map<String, Object> mappings) {
        this.variableMappingsStack.push(mappings);
    }

    public void popVariableMappings() {
        this.variableMappingsStack.pop();
    }

    public Object lookupVariable(String name) {
        for (Map<String, Object> mappings : this.variableMappingsStack) {
            if (!mappings.containsKey(name)) continue;
            return mappings.get(name);
        }
        throw new IllegalStateException("Can't find lambda variable " + name);
    }
}

