/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.Optional;

public class ComparisonTerm {

    public static interface ComparisonNullCheckFunction {
        public Optional<Boolean> checkNull(Object var1, Object var2);
    }

    public static interface EqualsCheckFunction {
        public boolean doCheck(boolean var1);
    }

    public static interface EqualsFunction {
        public boolean equals(Object var1, Object var2);
    }

    public static interface ComparisonCheckFunction {
        public boolean doCheck(int var1);
    }

    public static interface ComparisonFunction {
        public int compareTo(Object var1, Object var2);
    }

    public static class EqualsTerm
    implements Term {
        private final Term left;
        private final Term right;
        private final ComparisonNullCheckFunction nullCheckFunction;
        private final EqualsFunction equalsFunction;
        private final EqualsCheckFunction equalsCheckFunction;

        public EqualsTerm(Term left, Term right, ComparisonNullCheckFunction nullCheckFunction, EqualsFunction equalsFunction, EqualsCheckFunction equalsCheckFunction) {
            this.left = left;
            this.right = right;
            this.nullCheckFunction = nullCheckFunction;
            this.equalsFunction = equalsFunction;
            this.equalsCheckFunction = equalsCheckFunction;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            Object rightObject;
            Object leftObject = this.left.getValue(context);
            Optional<Boolean> nullCheck = this.nullCheckFunction.checkNull(leftObject, rightObject = this.right.getValue(context));
            if (nullCheck.isPresent()) {
                return nullCheck.get();
            }
            boolean equals = this.equalsFunction.equals(leftObject, rightObject);
            return this.equalsCheckFunction.doCheck(equals);
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BOOLEAN;
        }
    }

    public static class CompareToTerm
    implements Term {
        private final Term left;
        private final Term right;
        private final ComparisonNullCheckFunction nullCheckFunction;
        private final ComparisonFunction comparisonFunction;
        private final ComparisonCheckFunction comparisonCheckFunction;

        public CompareToTerm(Term left, Term right, ComparisonNullCheckFunction nullCheckFunction, ComparisonFunction comparisonFunction, ComparisonCheckFunction comparisonCheckFunction) {
            this.left = left;
            this.right = right;
            this.nullCheckFunction = nullCheckFunction;
            this.comparisonFunction = comparisonFunction;
            this.comparisonCheckFunction = comparisonCheckFunction;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            Object rightObject;
            Object leftObject = this.left.getValue(context);
            Optional<Boolean> nullCheck = this.nullCheckFunction.checkNull(leftObject, rightObject = this.right.getValue(context));
            if (nullCheck.isPresent()) {
                return nullCheck.get();
            }
            int compareTo = this.comparisonFunction.compareTo(leftObject, rightObject);
            return this.comparisonCheckFunction.doCheck(compareTo);
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BOOLEAN;
        }
    }
}

