/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.name.ColumnName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ForeignKeyTableTableJoin<KLeftT, KRightT>
implements ExecutionStep<KTableHolder<KLeftT>> {
    private final ExecutionStepPropertiesV1 properties;
    private final JoinType joinType;
    private final Optional<ColumnName> leftJoinColumnName;
    private final Optional<Expression> leftJoinExpression;
    private final Formats formats;
    private final ExecutionStep<KTableHolder<KLeftT>> leftSource;
    private final ExecutionStep<KTableHolder<KRightT>> rightSource;

    @JsonCreator
    public ForeignKeyTableTableJoin(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="joinType", required=true) JoinType joinType, @JsonProperty(value="leftJoinColumnName") Optional<ColumnName> leftJoinColumnName, @JsonProperty(value="leftJoinExpression") Optional<Expression> leftJoinExpression, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="leftSource", required=true) ExecutionStep<KTableHolder<KLeftT>> leftSource, @JsonProperty(value="rightSource", required=true) ExecutionStep<KTableHolder<KRightT>> rightSource) {
        this.properties = Objects.requireNonNull(props, "props");
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        if (joinType == JoinType.OUTER) {
            throw new IllegalArgumentException("OUTER join not supported.");
        }
        this.leftJoinColumnName = Objects.requireNonNull(leftJoinColumnName, "leftJoinColumnName");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.leftSource = Objects.requireNonNull(leftSource, "leftSource");
        this.rightSource = Objects.requireNonNull(rightSource, "rightSource");
        this.leftJoinExpression = Objects.requireNonNull(leftJoinExpression, "leftJoinExpression");
        if (!leftJoinColumnName.isPresent() && !leftJoinExpression.isPresent()) {
            throw new IllegalArgumentException("Either leftJoinColumnName or leftJoinExpression must be provided.");
        }
        if (leftJoinColumnName.isPresent() && leftJoinExpression.isPresent()) {
            throw new IllegalArgumentException("Either leftJoinColumnName or leftJoinExpression must be empty.");
        }
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return ImmutableList.of(this.leftSource, this.rightSource);
    }

    public ExecutionStep<KTableHolder<KLeftT>> getLeftSource() {
        return this.leftSource;
    }

    public ExecutionStep<KTableHolder<KRightT>> getRightSource() {
        return this.rightSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Optional<ColumnName> getLeftJoinColumnName() {
        return this.leftJoinColumnName;
    }

    public Optional<Expression> getLeftJoinExpression() {
        return this.leftJoinExpression;
    }

    public Formats getFormats() {
        return this.formats;
    }

    @Override
    public KTableHolder<KLeftT> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitForeignKeyTableTableJoin(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitForeignKeyTableTableJoin(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeignKeyTableTableJoin that = (ForeignKeyTableTableJoin)o;
        return Objects.equals(this.properties, that.properties) && this.joinType == that.joinType && Objects.equals(this.leftJoinColumnName, that.leftJoinColumnName) && Objects.equals(this.formats, that.formats) && Objects.equals(this.leftSource, that.leftSource) && Objects.equals(this.rightSource, that.rightSource) && Objects.equals(this.leftJoinExpression, that.leftJoinExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.joinType, this.leftJoinColumnName, this.formats, this.leftSource, this.rightSource, this.leftJoinExpression});
    }
}

