/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.formatter.ExpressionFormatter;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Objects;

@Immutable
public final class SelectExpression {
    private static final String FMT = "%s AS %s";
    private final ColumnName alias;
    private final Expression expression;

    private SelectExpression(ColumnName alias, Expression expression) {
        this.alias = Objects.requireNonNull(alias, "alias");
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    public static SelectExpression of(ColumnName name, Expression expression) {
        return new SelectExpression(name, expression);
    }

    public ColumnName getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectExpression that = (SelectExpression)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals((Object)this.expression, (Object)that.expression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this.expression});
    }

    public String toString() {
        return this.format(FormatOptions.none());
    }

    public String format(FormatOptions formatOptions) {
        return String.format(FMT, ExpressionFormatter.formatExpression(this.expression, formatOptions), this.alias.toString(formatOptions));
    }
}

