/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.serde.RefinementInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class TableSuppress<K>
implements ExecutionStep<KTableHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KTableHolder<K>> source;
    private final RefinementInfo refinementInfo;
    private final Formats internalFormats;

    public TableSuppress(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KTableHolder<K>> source, @JsonProperty(value="refinementInfo", required=true) RefinementInfo refinementInfo, @JsonProperty(value="internalFormats", required=true) Formats internalFormats) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.refinementInfo = Objects.requireNonNull(refinementInfo, "refinementInfo");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public RefinementInfo getRefinementInfo() {
        return this.refinementInfo;
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    public ExecutionStep<KTableHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KTableHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitTableSuppress(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitTableSuppress(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSuppress that = (TableSuppress)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.refinementInfo, that.refinementInfo) && Objects.equals(this.internalFormats, that.internalFormats);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.refinementInfo, this.internalFormats);
    }
}

