/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.runtime;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.KeySerdeFactory;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.serde.ValueSerdeFactory;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.serde.tracked.TrackedCallback;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.MetricsTagsUtil;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Windowed;

public final class RuntimeBuildContext {
    public static final String KSQL_TEST_TRACK_SERDE_TOPICS = "ksql.test.track.serde.topics";
    private final StreamsBuilder streamsBuilder;
    private final KsqlConfig ksqlConfig;
    private final ServiceContext serviceContext;
    private final ProcessingLogContext processingLogContext;
    private final FunctionRegistry functionRegistry;
    private final KeySerdeFactory keySerdeFactory;
    private final ValueSerdeFactory valueSerdeFactory;
    private final QueryId queryId;
    private final String applicationId;
    private final QuerySchemas schemas = new QuerySchemas();

    public static RuntimeBuildContext of(StreamsBuilder streamsBuilder, KsqlConfig ksqlConfig, ServiceContext serviceContext, ProcessingLogContext processingLogContext, FunctionRegistry functionRegistry, String applicationId, QueryId queryId) {
        return new RuntimeBuildContext(streamsBuilder, ksqlConfig, serviceContext, processingLogContext, functionRegistry, applicationId, queryId, (KeySerdeFactory)new GenericKeySerDe(queryId.toString()), (ValueSerdeFactory)new GenericRowSerDe(queryId.toString()));
    }

    @VisibleForTesting
    RuntimeBuildContext(StreamsBuilder streamsBuilder, KsqlConfig ksqlConfig, ServiceContext serviceContext, ProcessingLogContext processingLogContext, FunctionRegistry functionRegistry, String applicationId, QueryId queryId, KeySerdeFactory keySerdeFactory, ValueSerdeFactory valueSerdeFactory) {
        this.streamsBuilder = Objects.requireNonNull(streamsBuilder, "streamsBuilder");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.keySerdeFactory = Objects.requireNonNull(keySerdeFactory, "keySerdeFactory");
        this.valueSerdeFactory = Objects.requireNonNull(valueSerdeFactory, "valueSerdeFactory");
    }

    public ProcessingLogger getProcessingLogger(QueryContext queryContext) {
        return this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName(this.queryId, queryContext), MetricsTagsUtil.getMetricsTagsWithQueryId((String)this.queryId.toString(), Collections.emptyMap()));
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KsqlConfig getKsqlConfig() {
        return this.ksqlConfig;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public StreamsBuilder getStreamsBuilder() {
        return this.streamsBuilder;
    }

    public QuerySchemas getSchemas() {
        return this.schemas;
    }

    public Serde<GenericKey> buildKeySerde(FormatInfo format, PhysicalSchema schema, QueryContext queryContext) {
        String loggerNamePrefix = QueryLoggerUtil.queryLoggerName(this.queryId, queryContext);
        this.schemas.trackKeySerdeCreation(loggerNamePrefix, schema.logicalSchema(), KeyFormat.nonWindowed((FormatInfo)format, (SerdeFeatures)schema.keySchema().features()));
        return this.keySerdeFactory.create(format, schema.keySchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), loggerNamePrefix, this.processingLogContext, this.getSerdeTracker(loggerNamePrefix));
    }

    public Serde<Windowed<GenericKey>> buildKeySerde(FormatInfo format, WindowInfo window, PhysicalSchema schema, QueryContext queryContext) {
        String loggerNamePrefix = QueryLoggerUtil.queryLoggerName(this.queryId, queryContext);
        this.schemas.trackKeySerdeCreation(loggerNamePrefix, schema.logicalSchema(), KeyFormat.windowed((FormatInfo)format, (SerdeFeatures)schema.keySchema().features(), (WindowInfo)window));
        return this.keySerdeFactory.create(format, window, schema.keySchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), loggerNamePrefix, this.processingLogContext, this.getSerdeTracker(loggerNamePrefix));
    }

    public Serde<GenericRow> buildValueSerde(FormatInfo format, PhysicalSchema schema, QueryContext queryContext) {
        String loggerNamePrefix = QueryLoggerUtil.queryLoggerName(this.queryId, queryContext);
        this.schemas.trackValueSerdeCreation(loggerNamePrefix, schema.logicalSchema(), ValueFormat.of((FormatInfo)format, (SerdeFeatures)schema.valueSchema().features()));
        return this.valueSerdeFactory.create(format, schema.valueSchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), loggerNamePrefix, this.processingLogContext, this.getSerdeTracker(loggerNamePrefix));
    }

    private Optional<TrackedCallback> getSerdeTracker(String loggerNamePrefix) {
        if (System.getProperty(KSQL_TEST_TRACK_SERDE_TOPICS) == null) {
            return Optional.empty();
        }
        return Optional.of((topicName, key) -> this.schemas.trackSerdeOp(topicName, key, loggerNamePrefix));
    }

    public MaterializedFactory getMaterializedFactory() {
        return new MaterializedFactory();
    }
}

