/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class HoppingWindowExpression
extends KsqlWindowExpression {
    private final WindowTimeClause size;
    private final WindowTimeClause advanceBy;

    @JsonCreator
    public static HoppingWindowExpression of(@JsonProperty(value="size", required=true) WindowTimeClause size, @JsonProperty(value="advanceBy", required=true) WindowTimeClause advanceBy, @JsonProperty(value="retention") WindowTimeClause retention, @JsonProperty(value="gracePeriod") WindowTimeClause gracePeriod, @JsonProperty(value="emitStrategy") OutputRefinement emitStrategy) {
        return new HoppingWindowExpression(Optional.empty(), size, advanceBy, Optional.ofNullable(retention), Optional.ofNullable(gracePeriod), Optional.ofNullable(emitStrategy));
    }

    public HoppingWindowExpression(WindowTimeClause size, WindowTimeClause advanceBy) {
        this(Optional.empty(), size, advanceBy, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public HoppingWindowExpression(Optional<NodeLocation> location, WindowTimeClause size, WindowTimeClause advanceBy, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod) {
        this(location, size, advanceBy, retention, gracePeriod, Optional.empty());
    }

    public HoppingWindowExpression(Optional<NodeLocation> location, WindowTimeClause size, WindowTimeClause advanceBy, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod, Optional<OutputRefinement> emitStrategy) {
        super(location, retention, gracePeriod, emitStrategy);
        this.size = Objects.requireNonNull(size, "size");
        this.advanceBy = Objects.requireNonNull(advanceBy, "advanceBy");
    }

    @Override
    @JsonIgnore
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.HOPPING, Optional.of(this.size.toDuration()), (Optional)this.emitStrategy);
    }

    public WindowType getWindowType() {
        return WindowType.HOPPING;
    }

    public WindowTimeClause getSize() {
        return this.size;
    }

    public WindowTimeClause getAdvanceBy() {
        return this.advanceBy;
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitHoppingWindowExpression(this, context);
    }

    public String toString() {
        return " HOPPING ( SIZE " + this.size + " , ADVANCE BY " + this.advanceBy + this.retention.map(w -> " , RETENTION " + w).orElse("") + this.gracePeriod.map(g -> " , GRACE PERIOD " + g).orElse("") + " ) ";
    }

    public int hashCode() {
        return Objects.hash(this.size, this.advanceBy, this.retention, this.gracePeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HoppingWindowExpression hoppingWindowExpression = (HoppingWindowExpression)((Object)o);
        return Objects.equals(this.size, hoppingWindowExpression.size) && Objects.equals(this.advanceBy, hoppingWindowExpression.advanceBy) && Objects.equals(this.gracePeriod, hoppingWindowExpression.gracePeriod) && Objects.equals(this.retention, hoppingWindowExpression.retention);
    }
}

