/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.util.ParserUtil;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class ColumnReferenceParser {
    private ColumnReferenceParser() {
    }

    public static ColumnName parse(String text) {
        SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)text)));
        CommonTokenStream tokStream = new CommonTokenStream((TokenSource)lexer);
        SqlBaseParser parser = new SqlBaseParser((TokenStream)tokStream);
        SqlBaseParser.PrimaryExpressionContext primaryExpression = parser.primaryExpression();
        if (primaryExpression instanceof SqlBaseParser.ColumnReferenceContext) {
            return ColumnReferenceParser.resolve((SqlBaseParser.ColumnReferenceContext)primaryExpression).getReference();
        }
        if (primaryExpression instanceof SqlBaseParser.QualifiedColumnReferenceContext) {
            return ColumnReferenceParser.resolve((SqlBaseParser.QualifiedColumnReferenceContext)primaryExpression).getReference();
        }
        throw new ParseFailedException("Cannot parse text that is not column reference: " + text);
    }

    static UnqualifiedColumnReferenceExp resolve(SqlBaseParser.ColumnReferenceContext context) {
        return new UnqualifiedColumnReferenceExp(ParserUtil.getLocation(context), ColumnName.of((String)ParserUtil.getIdentifierText(context.identifier())));
    }

    static QualifiedColumnReferenceExp resolve(SqlBaseParser.QualifiedColumnReferenceContext context) {
        return new QualifiedColumnReferenceExp(ParserUtil.getLocation(context), SourceName.of((String)ParserUtil.getIdentifierText(context.identifier(0))), ColumnName.of((String)ParserUtil.getIdentifierText(context.identifier(1))));
    }
}

