/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.formatter.ExpressionFormatter;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.tree.GroupingElement;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.util.IdentifierUtil;
import java.util.List;
import java.util.Set;

public final class ExpressionFormatterUtil {
    private ExpressionFormatterUtil() {
    }

    public static String formatExpression(Expression expression) {
        return ExpressionFormatter.formatExpression((Expression)expression, (FormatOptions)FormatOptions.of(IdentifierUtil::needsQuotes));
    }

    public static String formatGroupBy(List<GroupingElement> groupingElements) {
        ImmutableList.Builder resultStrings = ImmutableList.builder();
        for (GroupingElement groupingElement : groupingElements) {
            resultStrings.add((Object)groupingElement.format());
        }
        return Joiner.on((String)", ").join((Iterable)resultStrings.build());
    }

    public static String formatGroupingSet(Set<Expression> groupingSet) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet.stream().map(ExpressionFormatterUtil::formatExpression).iterator()));
    }
}

