/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.tree.Statement;
import java.util.List;
import java.util.Objects;

public interface KsqlParser {
    public List<ParsedStatement> parse(String var1);

    public PreparedStatement<?> prepare(ParsedStatement var1, TypeRegistry var2);

    @Immutable
    public static final class PreparedStatement<T extends Statement> {
        private final String statementText;
        private final T statement;

        private PreparedStatement(String statementText, T statement) {
            this.statementText = Objects.requireNonNull(statementText, "statementText");
            this.statement = (Statement)((Object)Objects.requireNonNull(statement, "statement"));
        }

        public static <T extends Statement> PreparedStatement<T> of(String statementText, T statement) {
            return new PreparedStatement<T>(statementText, statement);
        }

        public String getStatementText() {
            return this.statementText;
        }

        public T getStatement() {
            return this.statement;
        }

        public String toString() {
            return this.statementText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreparedStatement that = (PreparedStatement)o;
            return Objects.equals(this.statementText, that.statementText) && Objects.equals(this.statement, that.statement);
        }

        public int hashCode() {
            return Objects.hash(this.statementText, this.statement);
        }
    }

    public static final class ParsedStatement {
        private final String statementText;
        private final SqlBaseParser.SingleStatementContext statement;

        private ParsedStatement(String statementText, SqlBaseParser.SingleStatementContext statement) {
            this.statementText = Objects.requireNonNull(statementText, "statementText");
            this.statement = Objects.requireNonNull(statement, "statement");
        }

        public static ParsedStatement of(String statementText, SqlBaseParser.SingleStatementContext statement) {
            return new ParsedStatement(statementText, statement);
        }

        public String getStatementText() {
            return this.statementText;
        }

        public SqlBaseParser.SingleStatementContext getStatement() {
            return this.statement;
        }
    }
}

