/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.confluent.ksql.execution.expression.formatter.ExpressionFormatter;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.ExpressionFormatterUtil;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.DropStatement;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.ListFunctions;
import io.confluent.ksql.parser.tree.ListStreams;
import io.confluent.ksql.parser.tree.ListTables;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.ShowColumns;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.util.IdentifierUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final FormatOptions FORMAT_OPTIONS = FormatOptions.of(IdentifierUtil::needsQuotes);

    private SqlFormatter() {
    }

    public static String formatSql(AstNode root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder).process(root, 0);
        return StringUtils.stripEnd((String)builder.toString(), (String)"\n");
    }

    private static String escapedName(Name name) {
        return name.toString(FORMAT_OPTIONS);
    }

    private static final class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;

        private Formatter(StringBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        protected Void visitNode(AstNode node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)node));
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            this.process(node.getSelect(), indent);
            this.append(indent, "FROM ");
            this.processRelation(node.getFrom(), indent);
            this.builder.append('\n');
            if (node.getWindow().isPresent()) {
                this.append(indent, "WINDOW" + node.getWindow().get().getKsqlWindowExpression().toString()).append('\n');
            }
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatterUtil.formatExpression(node.getWhere().get())).append('\n');
            }
            if (node.getGroupBy().isPresent()) {
                this.append(indent, "GROUP BY " + ExpressionFormatterUtil.formatGroupBy(node.getGroupBy().get().getGroupingElements())).append('\n');
            }
            if (node.getPartitionBy().isPresent()) {
                this.append(indent, "PARTITION BY " + ExpressionFormatterUtil.formatExpression(node.getPartitionBy().get())).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatterUtil.formatExpression(node.getHaving().get())).append('\n');
            }
            if (!node.isPullQuery()) {
                this.append(indent, "EMIT ");
                this.append(indent, node.getResultMaterialization().toString()).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().getAsInt()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            List<SelectItem> selectItems = node.getSelectItems();
            if (selectItems.size() > 1) {
                boolean first = true;
                for (SelectItem item : selectItems) {
                    this.builder.append(first ? "" : ",").append("\n  ").append(Formatter.indentString(indent));
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((AstNode)((Object)Iterables.getOnlyElement(selectItems)), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatterUtil.formatExpression(node.getExpression()));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append(node.getAlias().get().toString(FormatOptions.of(IdentifierUtil::needsQuotes)));
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            node.getSource().ifPresent(source -> this.builder.append(SqlFormatter.escapedName((Name)source)).append("."));
            this.builder.append("*");
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            String type = node.getType().getFormatted();
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            this.append(indent, type).append(" JOIN ");
            this.process(node.getRight(), indent);
            JoinCriteria criteria = node.getCriteria();
            node.getWithinExpression().map(e -> this.builder.append(e.toString()));
            JoinOn on = (JoinOn)criteria;
            this.builder.append(" ON (").append(ExpressionFormatterUtil.formatExpression(on.getExpression())).append(")");
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(' ').append(SqlFormatter.escapedName((Name)node.getAlias()));
            return null;
        }

        @Override
        protected Void visitCreateStream(CreateStream node, Integer indent) {
            this.builder.append("CREATE STREAM ");
            this.formatCreate(node);
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            this.formatCreate(node);
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            this.builder.append("\n");
            node.getQueryId().ifPresent(queryId -> this.append(indent, (String)queryId));
            node.getStatement().ifPresent(stmt -> {
                Void cfr_ignored_0 = (Void)this.process((AstNode)((Object)stmt), indent);
            });
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("DESCRIBE ").append(SqlFormatter.escapedName((Name)node.getTable()));
            return null;
        }

        @Override
        protected Void visitShowFunctions(ListFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            return null;
        }

        @Override
        protected Void visitCreateStreamAsSelect(CreateStreamAsSelect node, Integer indent) {
            this.builder.append("CREATE STREAM ");
            this.formatCreateAs(node, indent);
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            this.formatCreateAs(node, indent);
            return null;
        }

        @Override
        protected Void visitInsertInto(InsertInto node, Integer indent) {
            this.builder.append("INSERT INTO ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getTarget()));
            this.builder.append(" ");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitDropStream(DropStream node, Integer context) {
            this.visitDrop(node, "STREAM");
            return null;
        }

        @Override
        protected Void visitInsertValues(InsertValues node, Integer context) {
            this.builder.append("INSERT INTO ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getTarget()));
            this.builder.append(" ");
            if (!node.getColumns().isEmpty()) {
                this.builder.append(node.getColumns().stream().map(x$0 -> SqlFormatter.escapedName(x$0)).collect(Collectors.joining(", ", "(", ") ")));
            }
            this.builder.append("VALUES ");
            this.builder.append("(");
            this.builder.append(node.getValues().stream().map(ExpressionFormatterUtil::formatExpression).collect(Collectors.joining(", ")));
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.visitDrop(node, "TABLE");
            return null;
        }

        @Override
        protected Void visitTerminateQuery(TerminateQuery node, Integer context) {
            this.builder.append("TERMINATE ");
            this.builder.append(node.getQueryId().map(QueryId::toString).orElse("ALL"));
            return null;
        }

        @Override
        protected Void visitListStreams(ListStreams node, Integer context) {
            this.builder.append("SHOW STREAMS");
            if (node.getShowExtended()) {
                this.visitExtended();
            }
            return null;
        }

        @Override
        protected Void visitListTables(ListTables node, Integer context) {
            this.builder.append("SHOW TABLES");
            if (node.getShowExtended()) {
                this.visitExtended();
            }
            return null;
        }

        @Override
        protected Void visitUnsetProperty(UnsetProperty node, Integer context) {
            this.builder.append("UNSET '");
            this.builder.append(node.getPropertyName());
            this.builder.append("'");
            return null;
        }

        @Override
        protected Void visitSetProperty(SetProperty node, Integer context) {
            this.builder.append("SET '");
            this.builder.append(node.getPropertyName());
            this.builder.append("'='");
            this.builder.append(node.getPropertyValue());
            this.builder.append("'");
            return null;
        }

        private void visitExtended() {
            this.builder.append(" EXTENDED");
        }

        @Override
        public Void visitRegisterType(RegisterType node, Integer context) {
            this.builder.append("CREATE TYPE ");
            this.builder.append(FORMAT_OPTIONS.escape(node.getName()));
            this.builder.append(" AS ");
            this.builder.append(ExpressionFormatterUtil.formatExpression((Expression)node.getType()));
            this.builder.append(";");
            return null;
        }

        private void visitDrop(DropStatement node, String sourceType) {
            this.builder.append("DROP ");
            this.builder.append(sourceType);
            this.builder.append(" ");
            if (node.getIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            if (node.isDeleteTopic()) {
                this.builder.append(" DELETE TOPIC");
            }
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(SqlFormatter.escapedName((Name)((Table)relation).getName())).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private void processPartitionBy(Optional<Expression> partitionByColumn, Integer indent) {
            partitionByColumn.ifPresent(partitionBy -> this.append(indent, "PARTITION BY " + ExpressionFormatterUtil.formatExpression(partitionBy)).append('\n'));
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }

        private void formatCreate(CreateSource node) {
            String tableProps;
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            String elements = node.getElements().stream().map(Formatter::formatTableElement).collect(Collectors.joining(", "));
            if (!elements.isEmpty()) {
                this.builder.append(" (").append(elements).append(")");
            }
            if (!(tableProps = node.getProperties().toString()).isEmpty()) {
                this.builder.append(" WITH (").append(tableProps).append(")");
            }
            this.builder.append(";");
        }

        private void formatCreateAs(CreateAsSelect node, Integer indent) {
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            String tableProps = node.getProperties().toString();
            if (!tableProps.isEmpty()) {
                this.builder.append(" WITH (").append(tableProps).append(")");
            }
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
        }

        private static String formatTableElement(TableElement e) {
            return SqlFormatter.escapedName((Name)e.getName()) + " " + ExpressionFormatter.formatExpression((Expression)e.getType(), (FormatOptions)FormatOptions.of(IdentifierUtil::needsQuotes)) + (e.getNamespace() == TableElement.Namespace.KEY ? " KEY" : "");
        }
    }
}

