/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.properties.with;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.ColumnReferenceParser;
import io.confluent.ksql.parser.properties.with.PropertiesConfig;
import io.confluent.ksql.properties.with.CreateAsConfigs;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;

@Immutable
public final class CreateSourceAsProperties {
    private final PropertiesConfig props;

    public static CreateSourceAsProperties none() {
        return new CreateSourceAsProperties((Map<String, Literal>)ImmutableMap.of());
    }

    public static CreateSourceAsProperties from(Map<String, Literal> literals) {
        try {
            return new CreateSourceAsProperties(literals);
        }
        catch (ConfigException e) {
            String message = e.getMessage().replace("configuration", "property");
            throw new KsqlException(message, (Throwable)e);
        }
    }

    private CreateSourceAsProperties(Map<String, Literal> originals) {
        this.props = new PropertiesConfig(CreateAsConfigs.CONFIG_METADATA, originals);
        this.props.validateDateTimeFormat("TIMESTAMP_FORMAT");
    }

    public Optional<Format> getValueFormat() {
        return this.getFormatInfo().map(FormatFactory::of);
    }

    public Optional<String> getKafkaTopic() {
        return Optional.ofNullable(this.props.getString("KAFKA_TOPIC"));
    }

    public Optional<Integer> getPartitions() {
        return Optional.ofNullable(this.props.getInt("PARTITIONS"));
    }

    public Optional<Short> getReplicas() {
        return Optional.ofNullable(this.props.getShort("REPLICAS"));
    }

    public Optional<ColumnName> getTimestampColumnName() {
        return Optional.ofNullable(this.props.getString("TIMESTAMP")).map(ColumnReferenceParser::parse);
    }

    public Optional<String> getTimestampFormat() {
        return Optional.ofNullable(this.props.getString("TIMESTAMP_FORMAT"));
    }

    public Optional<Boolean> getWrapSingleValues() {
        return Optional.ofNullable(this.props.getBoolean("WRAP_SINGLE_VALUE"));
    }

    public Optional<FormatInfo> getFormatInfo() {
        return Optional.ofNullable(this.props.getString("VALUE_FORMAT")).map(format -> FormatInfo.of((String)format, this.getFormatProperties()));
    }

    public Map<String, String> getFormatProperties() {
        String delimiter;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String schemaName = this.props.getString("VALUE_AVRO_SCHEMA_FULL_NAME");
        if (schemaName != null) {
            builder.put((Object)"fullSchemaName", (Object)schemaName);
        }
        if ((delimiter = this.props.getString("VALUE_DELIMITER")) != null) {
            builder.put((Object)"delimiter", (Object)delimiter);
        }
        return builder.build();
    }

    public CreateSourceAsProperties withTopic(String name, int partitions, short replicas) {
        Map<String, Literal> originals = this.props.copyOfOriginalLiterals();
        originals.put("KAFKA_TOPIC", (Literal)new StringLiteral(name));
        originals.put("PARTITIONS", (Literal)new IntegerLiteral(partitions));
        originals.put("REPLICAS", (Literal)new IntegerLiteral((int)replicas));
        return new CreateSourceAsProperties(originals);
    }

    public String toString() {
        return this.props.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSourceAsProperties that = (CreateSourceAsProperties)o;
        return Objects.equals((Object)this.props, (Object)that.props);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.props});
    }
}

