/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.properties.with;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.properties.with.ConfigMetaData;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

@EffectivelyImmutable
final class PropertiesConfig
extends AbstractConfig {
    private final ConfigMetaData configDetails;
    private final ImmutableMap<String, Literal> originalLiterals;

    PropertiesConfig(ConfigMetaData configDetails, Map<String, Literal> originals) {
        super((ConfigDef)configDetails.getConfigDef(), PropertiesConfig.toValues(configDetails.getShortConfigs(), Objects.requireNonNull(originals, "originals")), false);
        PropertiesConfig.throwOnUnknownProperty(configDetails.getConfigNames(), originals);
        this.configDetails = Objects.requireNonNull(configDetails, "configDetails");
        this.originalLiterals = ImmutableMap.copyOf(originals.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(), Map.Entry::getValue)));
    }

    public String toString() {
        return this.configDetails.getOrderedConfigNames().stream().filter(arg_0 -> this.originalLiterals.containsKey(arg_0)).map(name -> name + "=" + this.originalLiterals.get(name)).collect(Collectors.joining(", "));
    }

    public Map<String, Literal> copyOfOriginalLiterals() {
        return new HashMap<String, Literal>((Map<String, Literal>)this.originalLiterals);
    }

    void validateDateTimeFormat(String configName) {
        Object value = this.originals().get(configName);
        if (value == null) {
            return;
        }
        String pattern = value.toString();
        try {
            DateTimeFormatter.ofPattern(pattern);
        }
        catch (Exception e) {
            throw new KsqlException("Invalid datatime format for config:" + configName + ", reason:" + e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Object> toValues(Set<String> shortConfigProperties, Map<String, Literal> literals) {
        Map<String, Object> values = literals.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(), e -> ((Literal)e.getValue()).getValue()));
        shortConfigProperties.forEach(configName -> {
            Object rf = values.get(configName);
            if (rf instanceof Number) {
                values.put((String)configName, ((Number)rf).shortValue());
            }
        });
        return values;
    }

    private static void throwOnUnknownProperty(Set<String> configNames, Map<String, ?> originals) {
        Set providedNames = originals.keySet().stream().map(String::toUpperCase).collect(Collectors.toSet());
        Sets.SetView onlyInProvided = Sets.difference(providedNames, configNames);
        if (!onlyInProvided.isEmpty()) {
            throw new KsqlException("Invalid config variable(s) in the WITH clause: " + String.join((CharSequence)",", (Iterable<? extends CharSequence>)onlyInProvided));
        }
    }
}

