/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.SelectItem;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AllColumns
extends SelectItem {
    private final Optional<SourceName> source;

    public AllColumns(Optional<SourceName> source) {
        this(Optional.empty(), source);
    }

    public AllColumns(Optional<NodeLocation> location, Optional<SourceName> source) {
        super(location);
        this.source = Objects.requireNonNull(source, "source");
    }

    public Optional<SourceName> getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAllColumns(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AllColumns that = (AllColumns)((Object)o);
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        return this.source.map(qualifiedName -> qualifiedName + ".*").orElse("*");
    }
}

