/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class CreateConnector
extends Statement {
    private final String name;
    private final ImmutableMap<String, Literal> config;
    private final Type type;

    public CreateConnector(Optional<NodeLocation> location, String name, Map<String, Literal> config, Type type) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.config = ImmutableMap.copyOf(Objects.requireNonNull(config, "config"));
        this.type = Objects.requireNonNull(type, "type");
    }

    public CreateConnector(String name, Map<String, Literal> config, Type type) {
        this(Optional.empty(), name, config, type);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Literal> getConfig() {
        return this.config;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateConnector that = (CreateConnector)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.config, that.config) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.config, this.type});
    }

    public String toString() {
        return "CreateConnector{name='" + this.name + '\'' + ", config=" + this.config + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        SOURCE,
        SINK;

    }
}

