/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.GroupingElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class GroupBy
extends AstNode {
    private final ImmutableList<GroupingElement> groupingElements;

    public GroupBy(List<GroupingElement> groupingElements) {
        this(Optional.empty(), groupingElements);
    }

    public GroupBy(Optional<NodeLocation> location, List<GroupingElement> groupingElements) {
        super(location);
        this.groupingElements = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingElements, "groupingElements"));
    }

    public List<GroupingElement> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupBy(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GroupBy groupBy = (GroupBy)((Object)o);
        return Objects.equals(this.groupingElements, groupBy.groupingElements);
    }

    public int hashCode() {
        return Objects.hash(this.groupingElements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("groupingElements", this.groupingElements).toString();
    }
}

