/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.WithinExpression;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Join
extends Relation {
    private final Type type;
    private final Relation left;
    private final Relation right;
    private final JoinCriteria criteria;
    private final Optional<WithinExpression> withinExpression;

    public Join(Type type, Relation left, Relation right, JoinCriteria criteria, Optional<WithinExpression> withinExpression) {
        this(Optional.empty(), type, left, right, criteria, withinExpression);
    }

    public Join(Optional<NodeLocation> location, Type type, Relation left, Relation right, JoinCriteria criteria, Optional<WithinExpression> withinExpression) {
        super(location);
        this.type = Objects.requireNonNull(type, "type");
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
        this.criteria = Objects.requireNonNull(criteria, "criteria");
        this.withinExpression = Objects.requireNonNull(withinExpression, "withinExpression");
    }

    public Type getType() {
        return this.type;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public JoinCriteria getCriteria() {
        return this.criteria;
    }

    public Optional<WithinExpression> getWithinExpression() {
        return this.withinExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("type", (Object)this.type).add("left", (Object)this.left).add("right", (Object)this.right).add("criteria", (Object)this.criteria).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)((Object)o);
        return this.type == join.type && Objects.equals((Object)this.left, (Object)join.left) && Objects.equals((Object)this.right, (Object)join.right) && Objects.equals(this.criteria, join.criteria) && Objects.equals(this.withinExpression, join.withinExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right, this.criteria, this.withinExpression});
    }

    public static enum Type {
        INNER("INNER"),
        LEFT("LEFT OUTER"),
        OUTER("FULL OUTER");

        private final String formattedText;

        private Type(String formattedText) {
            this.formattedText = Objects.requireNonNull(formattedText, "formattedText");
        }

        public String getFormatted() {
            return this.formattedText;
        }
    }
}

