/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.ResultMaterialization;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.util.KsqlPreconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@Immutable
public class Query
extends Statement {
    private final Select select;
    private final Relation from;
    private final Optional<WindowExpression> window;
    private final Optional<Expression> where;
    private final Optional<GroupBy> groupBy;
    private final Optional<Expression> partitionBy;
    private final Optional<Expression> having;
    private final ResultMaterialization resultMaterialization;
    private final boolean pullQuery;
    private final OptionalInt limit;

    public Query(Optional<NodeLocation> location, Select select, Relation from, Optional<WindowExpression> window, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> partitionBy, Optional<Expression> having, ResultMaterialization resultMaterialization, boolean pullQuery, OptionalInt limit) {
        super(location);
        this.select = Objects.requireNonNull(select, "select");
        this.from = Objects.requireNonNull(from, "from");
        this.window = Objects.requireNonNull(window, "window");
        this.where = Objects.requireNonNull(where, "where");
        this.groupBy = Objects.requireNonNull(groupBy, "groupBy");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy");
        this.having = Objects.requireNonNull(having, "having");
        this.resultMaterialization = Objects.requireNonNull(resultMaterialization, "resultMaterialization");
        this.pullQuery = pullQuery;
        this.limit = Objects.requireNonNull(limit, "limit");
        KsqlPreconditions.checkArgument((!partitionBy.isPresent() || !groupBy.isPresent() ? 1 : 0) != 0, (String)"Queries only support one of PARTITION BY and GROUP BY");
    }

    public Select getSelect() {
        return this.select;
    }

    public Relation getFrom() {
        return this.from;
    }

    public Optional<WindowExpression> getWindow() {
        return this.window;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public ResultMaterialization getResultMaterialization() {
        return this.resultMaterialization;
    }

    public boolean isPullQuery() {
        return this.pullQuery;
    }

    public OptionalInt getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("select", (Object)this.select).add("from", (Object)this.from).add("window", this.window.orElse(null)).add("where", this.where.orElse(null)).add("groupBy", this.groupBy.orElse(null)).add("partitionBy", this.partitionBy.orElse(null)).add("having", this.having.orElse(null)).add("resultMaterialization", (Object)this.resultMaterialization).add("pullQuery", this.pullQuery).add("limit", (Object)this.limit).omitNullValues().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)((Object)obj);
        return this.pullQuery == o.pullQuery && Objects.equals((Object)this.select, (Object)o.select) && Objects.equals((Object)this.from, (Object)o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.window, o.window) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.partitionBy, o.partitionBy) && Objects.equals(this.having, o.having) && Objects.equals((Object)this.resultMaterialization, (Object)o.resultMaterialization) && Objects.equals(this.limit, o.limit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.select, this.from, this.where, this.window, this.groupBy, this.having, this.resultMaterialization, this.pullQuery, this.limit});
    }
}

