/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.ExpressionFormatterUtil;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.GroupingElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class SimpleGroupBy
extends GroupingElement {
    private final ImmutableList<Expression> columns;

    public SimpleGroupBy(List<Expression> columns) {
        this(Optional.empty(), columns);
    }

    public SimpleGroupBy(Optional<NodeLocation> location, List<Expression> columns) {
        super(location);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
    }

    public List<Expression> getColumns() {
        return this.columns;
    }

    @Override
    public List<Set<Expression>> enumerateGroupingSets() {
        return ImmutableList.of((Object)ImmutableSet.copyOf(this.columns));
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleGroupBy(this, context);
    }

    @Override
    public String format() {
        ImmutableSet columns = ImmutableSet.copyOf(this.columns);
        if (columns.size() == 1) {
            return ExpressionFormatterUtil.formatExpression((Expression)Iterables.getOnlyElement((Iterable)columns));
        }
        return ExpressionFormatterUtil.formatGroupingSet((Set<Expression>)columns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SimpleGroupBy that = (SimpleGroupBy)((Object)o);
        return Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("columns", this.columns).toString();
    }
}

