/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SingleColumn
extends SelectItem {
    private final Optional<ColumnName> alias;
    private final Expression expression;

    public SingleColumn(Expression expression, Optional<ColumnName> alias) {
        this(Optional.empty(), expression, alias);
    }

    public SingleColumn(Optional<NodeLocation> location, Expression expression, Optional<ColumnName> alias) {
        super(location);
        SchemaUtil.systemColumnNames().forEach(columnName -> SingleColumn.checkForReservedToken(expression, alias, columnName));
        this.expression = Objects.requireNonNull(expression, "expression");
        this.alias = Objects.requireNonNull(alias, "alias");
    }

    public SingleColumn copyWithExpression(Expression expression) {
        return new SingleColumn(this.getLocation(), expression, this.alias);
    }

    private static void checkForReservedToken(Expression expression, Optional<ColumnName> alias, ColumnName reservedToken) {
        String text;
        if (!alias.isPresent()) {
            return;
        }
        if (alias.get().name().equalsIgnoreCase(reservedToken.name()) && !(text = expression.toString()).substring(text.indexOf(".") + 1).equalsIgnoreCase(reservedToken.name())) {
            throw new ParseFailedException(reservedToken.name() + " is a reserved system column name. You cannot use it as an alias for a column.");
        }
    }

    public Optional<ColumnName> getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)((Object)obj);
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    public String toString() {
        return "SingleColumn{, alias=" + this.alias + ", expression=" + this.expression + '}';
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }
}

