/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import java.util.Objects;

@Immutable
public final class Sink {
    private final SourceName name;
    private final boolean createSink;
    private final CreateSourceAsProperties properties;

    public static Sink of(SourceName name, boolean createSink, CreateSourceAsProperties properties) {
        return new Sink(name, createSink, properties);
    }

    private Sink(SourceName name, boolean createSink, CreateSourceAsProperties properties) {
        this.name = Objects.requireNonNull(name, "name");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.createSink = createSink;
    }

    public SourceName getName() {
        return this.name;
    }

    public boolean shouldCreateSink() {
        return this.createSink;
    }

    public CreateSourceAsProperties getProperties() {
        return this.properties;
    }
}

