/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@Immutable
public final class TableElements
implements Iterable<TableElement> {
    private final ImmutableList<TableElement> elements;

    public static TableElements of(TableElement ... elements) {
        return new TableElements((ImmutableList<TableElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static TableElements of(List<TableElement> elements) {
        return new TableElements((ImmutableList<TableElement>)ImmutableList.copyOf(elements));
    }

    @Override
    public Iterator<TableElement> iterator() {
        return this.elements.iterator();
    }

    public Stream<TableElement> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableElements that = (TableElements)o;
        return Objects.equals(this.elements, that.elements);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public String toString() {
        return this.elements.toString();
    }

    public LogicalSchema toLogicalSchema(boolean withImplicitColumns) {
        if (Iterables.isEmpty((Iterable)this)) {
            throw new KsqlException("No columns supplied.");
        }
        LogicalSchema.Builder builder = withImplicitColumns ? LogicalSchema.builder() : LogicalSchema.builder().noImplicitColumns();
        for (TableElement tableElement : this) {
            ColumnName fieldName = tableElement.getName();
            SqlType fieldType = tableElement.getType().getSqlType();
            if (tableElement.getNamespace() == TableElement.Namespace.KEY) {
                builder.keyColumn(fieldName, fieldType);
                continue;
            }
            builder.valueColumn(fieldName, fieldType);
        }
        return builder.build();
    }

    private TableElements(ImmutableList<TableElement> elements) {
        this.elements = Objects.requireNonNull(elements, "elements");
        this.throwOnDuplicateNames();
    }

    private void throwOnDuplicateNames() {
        String duplicates = this.elements.stream().collect(Collectors.groupingBy(TableElement::getName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).map(Name::toString).collect(Collectors.joining(", "));
        if (!duplicates.isEmpty()) {
            throw new KsqlException("Duplicate column names: " + duplicates);
        }
    }
}

