/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.SqlValueCoercer;
import io.confluent.ksql.schema.ksql.types.Field;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.kafka.connect.data.Struct;

public enum DefaultSqlValueCoercer implements SqlValueCoercer
{
    INSTANCE;

    private static final Map<SqlBaseType, BiFunction<Number, SqlType, Optional<Number>>> UPCASTER;

    @Override
    public Optional<?> coerce(Object value, SqlType targetType) {
        return DefaultSqlValueCoercer.doCoerce(value, targetType);
    }

    private static Optional<?> doCoerce(Object value, SqlType targetType) {
        switch (targetType.baseType()) {
            case ARRAY: {
                return DefaultSqlValueCoercer.coerceArray(value, (SqlArray)targetType);
            }
            case MAP: {
                return DefaultSqlValueCoercer.coerceMap(value, (SqlMap)targetType);
            }
            case STRUCT: {
                return DefaultSqlValueCoercer.coerceStruct(value, (SqlStruct)targetType);
            }
        }
        SqlBaseType valueSqlType = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
        if (valueSqlType.equals((Object)targetType.baseType())) {
            return Optional.of(value);
        }
        if (!(value instanceof Number) || !valueSqlType.canImplicitlyCast(targetType.baseType())) {
            return Optional.empty();
        }
        return UPCASTER.get(targetType.baseType()).apply((Number)value, targetType);
    }

    private static Optional<?> coerceStruct(Object value, SqlStruct targetType) {
        if (!(value instanceof Struct)) {
            return Optional.empty();
        }
        Struct struct = (Struct)value;
        Struct coerced = new Struct(SchemaConverters.sqlToConnectConverter().toConnectSchema((SqlType)targetType));
        for (org.apache.kafka.connect.data.Field field : coerced.schema().fields()) {
            Optional sqlField = targetType.field(field.name());
            if (!sqlField.isPresent()) {
                return Optional.empty();
            }
            if (struct.schema().field(field.name()) == null) continue;
            Optional<?> val = DefaultSqlValueCoercer.doCoerce(struct.get(field), ((Field)sqlField.get()).type());
            val.ifPresent(v -> coerced.put(field.name(), v));
        }
        return Optional.of(coerced);
    }

    private static Optional<?> coerceArray(Object value, SqlArray targetType) {
        if (!(value instanceof List)) {
            return Optional.empty();
        }
        List list = (List)value;
        ImmutableList.Builder coerced = ImmutableList.builder();
        for (Object el : list) {
            Optional<?> coercedEl = DefaultSqlValueCoercer.doCoerce(el, targetType.getItemType());
            if (!coercedEl.isPresent()) {
                return Optional.empty();
            }
            coerced.add(coercedEl.get());
        }
        return Optional.of(coerced.build());
    }

    private static Optional<?> coerceMap(Object value, SqlMap targetType) {
        if (!(value instanceof Map)) {
            return Optional.empty();
        }
        Map map = (Map)value;
        HashMap coerced = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Optional<?> coercedKey = DefaultSqlValueCoercer.doCoerce(entry.getKey(), (SqlType)SqlTypes.STRING);
            Optional<?> coercedValue = DefaultSqlValueCoercer.doCoerce(entry.getValue(), targetType.getValueType());
            if (!coercedKey.isPresent() || !coercedValue.isPresent()) {
                return Optional.empty();
            }
            coerced.put(coercedKey.get(), coercedValue.get());
        }
        return Optional.of(coerced);
    }

    static {
        UPCASTER = ImmutableMap.builder().put((Object)SqlBaseType.INTEGER, (num, type) -> Optional.of(num.intValue())).put((Object)SqlBaseType.BIGINT, (num, type) -> Optional.of(num.longValue())).put((Object)SqlBaseType.DOUBLE, (num, type) -> Optional.of(num.doubleValue())).put((Object)SqlBaseType.DECIMAL, (num, type) -> {
            try {
                return Optional.ofNullable(DecimalUtil.ensureFit((BigDecimal)new BigDecimal(String.format("%s", num)), (SqlDecimal)((SqlDecimal)type)));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }).build();
    }
}

