/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AlterOption
extends AstNode {
    private final String columnName;
    private final Type type;

    public AlterOption(String columnName, Type type) {
        this(Optional.empty(), columnName, type);
    }

    public AlterOption(Optional<NodeLocation> location, String columnName, Type type) {
        super(location);
        this.columnName = columnName;
        this.type = type;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "AlterOption{columnName='" + this.columnName + '\'' + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AlterOption that = (AlterOption)((Object)o);
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.type);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterOption(this, context);
    }
}

