/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.TableElements;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Immutable
public abstract class CreateSource
extends Statement {
    private final SourceName name;
    private final TableElements elements;
    private final boolean notExists;
    private final CreateSourceProperties properties;
    private final boolean orReplace;

    CreateSource(Optional<NodeLocation> location, SourceName name, TableElements elements, boolean orReplace, boolean notExists, CreateSourceProperties properties) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.elements = Objects.requireNonNull(elements, "elements");
        this.orReplace = orReplace;
        this.notExists = notExists;
        this.properties = Objects.requireNonNull(properties, "properties");
        CreateSource.throwOnMultipleKeyColumns(elements);
    }

    public CreateSourceProperties getProperties() {
        return this.properties;
    }

    public SourceName getName() {
        return this.name;
    }

    public TableElements getElements() {
        return this.elements;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public abstract CreateSource copyWith(TableElements var1, CreateSourceProperties var2);

    public int hashCode() {
        return Objects.hash(this.name, this.elements, this.orReplace, this.notExists, this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSource)) {
            return false;
        }
        CreateSource that = (CreateSource)((Object)o);
        return this.notExists == that.notExists && this.orReplace == that.orReplace && Objects.equals(this.name, that.name) && Objects.equals(this.elements, that.elements) && Objects.equals(this.properties, that.properties);
    }

    private static void throwOnMultipleKeyColumns(TableElements elements) {
        List keys = elements.stream().filter(e -> e.getNamespace().isKey()).collect(Collectors.toList());
        if (keys.size() > 1) {
            String namesAndLocs = keys.stream().map(tableElement -> tableElement.getName() + tableElement.getLocation().map(nl -> " (" + nl + ")").orElse("")).collect(Collectors.joining(", "));
            throw new ParseFailedException("Only single KEY column supported. Multiple KEY columns found: " + namesAndLocs);
        }
    }
}

