/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class DefineVariable
extends Statement {
    private final String variableName;
    private final String variableValue;

    public DefineVariable(Optional<NodeLocation> location, String variableName, String variableValue) {
        super(location);
        this.variableName = Objects.requireNonNull(variableName, "variableName");
        this.variableValue = Objects.requireNonNull(variableValue, "variableValue");
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDefineVariable(this, context);
    }

    public int hashCode() {
        return Objects.hash(this.variableName, this.variableValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefineVariable that = (DefineVariable)((Object)o);
        return Objects.equals(this.variableName, that.variableName) && Objects.equals(this.variableValue, that.variableValue);
    }

    public String toString() {
        return "DefineVariable{name=" + this.variableName + ", value=" + this.variableValue + '}';
    }
}

