/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class GroupBy
extends AstNode {
    private final ImmutableList<Expression> groupingExpressions;

    public GroupBy(Optional<NodeLocation> location, List<Expression> groupingExpressions) {
        super(location);
        this.groupingExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingExpressions, "groupingElements"));
        HashSet groupBys = new HashSet(groupingExpressions.size());
        if (groupingExpressions.isEmpty()) {
            throw new KsqlException("GROUP BY requires at least one expression");
        }
        groupingExpressions.forEach(exp -> {
            if (!groupBys.add(exp)) {
                throw new KsqlException("Duplicate GROUP BY expression: " + exp);
            }
        });
    }

    public List<Expression> getGroupingExpressions() {
        return this.groupingExpressions;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupBy(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GroupBy groupBy = (GroupBy)((Object)o);
        return Objects.equals(this.groupingExpressions, groupBy.groupingExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.groupingExpressions);
    }

    public String toString() {
        return "GroupBy{groupingExpressions=" + this.groupingExpressions + '}';
    }
}

