/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QueryContainer;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class InsertInto
extends Statement
implements QueryContainer {
    private final SourceName target;
    private final Query query;

    public InsertInto(SourceName target, Query query) {
        this(Optional.empty(), target, query);
    }

    public InsertInto(Optional<NodeLocation> location, SourceName target, Query query) {
        super(location);
        this.target = Objects.requireNonNull(target, "target");
        this.query = Objects.requireNonNull(query, "query");
    }

    public SourceName getTarget() {
        return this.target;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public Sink getSink() {
        return Sink.of(this.target, false, false, CreateSourceAsProperties.none());
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsertInto(this, context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.target, this.query});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsertInto o = (InsertInto)obj;
        return Objects.equals(this.target, o.target) && Objects.equals((Object)this.query, (Object)o.query);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("query", (Object)this.query).toString();
    }
}

