/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class PartitionBy
extends AstNode {
    private final Expression expression;

    public PartitionBy(Optional<NodeLocation> location, Expression partitionBy) {
        super(location);
        this.expression = Objects.requireNonNull(partitionBy, "partitionBy");
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPartitionBy(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PartitionBy groupBy = (PartitionBy)((Object)o);
        return Objects.equals(this.expression, groupBy.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    public String toString() {
        return "PartitionBy{expression=" + this.expression + '}';
    }
}

