/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TableElement
extends AstNode {
    private final Namespace namespace;
    private final ColumnName name;
    private final Type type;

    public TableElement(Namespace namespace, ColumnName name, Type type) {
        this(Optional.empty(), namespace, name, type);
    }

    public TableElement(Optional<NodeLocation> location, Namespace namespace, ColumnName name, Type type) {
        super(location);
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
    }

    public ColumnName getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableElement(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TableElement o = (TableElement)((Object)obj);
        return Objects.equals(this.name, o.name) && Objects.equals(this.type, o.type) && Objects.equals((Object)this.namespace, (Object)o.namespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.namespace});
    }

    public String toString() {
        return "TableElement{name='" + this.name + '\'' + ", type=" + this.type + ", namespace=" + (Object)((Object)this.namespace) + '}';
    }

    public static enum Namespace {
        PRIMARY_KEY,
        KEY,
        VALUE;


        public boolean isKey() {
            return this != VALUE;
        }
    }
}

