/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class UnsetProperty
extends Statement {
    private final String propertyName;

    public UnsetProperty(Optional<NodeLocation> location, String propertyName) {
        super(location);
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnsetProperty(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsetProperty)) {
            return false;
        }
        UnsetProperty that = (UnsetProperty)((Object)o);
        return Objects.equals(this.propertyName, that.propertyName);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName);
    }

    public String toString() {
        return "UnsetProperty{propertyName='" + this.propertyName + '\'' + '}';
    }
}

