/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Immutable
public class WindowExpression
extends AstNode {
    private final String windowName;
    private final KsqlWindowExpression ksqlWindowExpression;

    public WindowExpression(String windowName, KsqlWindowExpression ksqlWindowExpression) {
        this(Optional.empty(), windowName, ksqlWindowExpression);
    }

    public WindowExpression(Optional<NodeLocation> location, String windowName, KsqlWindowExpression ksqlWindowExpression) {
        super(location);
        this.windowName = Objects.requireNonNull(windowName, "windowName");
        this.ksqlWindowExpression = Objects.requireNonNull(ksqlWindowExpression, "ksqlWindowExpression");
    }

    public KsqlWindowExpression getKsqlWindowExpression() {
        return this.ksqlWindowExpression;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WindowExpression that = (WindowExpression)((Object)o);
        return Objects.equals(this.windowName, that.windowName) && Objects.equals(this.ksqlWindowExpression, that.ksqlWindowExpression);
    }

    public int hashCode() {
        return Objects.hash(this.windowName, this.ksqlWindowExpression);
    }

    public String toString() {
        return " WINDOW " + this.windowName + " " + this.ksqlWindowExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowExpression(this, context);
    }

    public static TimeUnit getWindowUnit(String windowUnitString) {
        try {
            if (!windowUnitString.endsWith("S")) {
                return TimeUnit.valueOf(windowUnitString + "S");
            }
            return TimeUnit.valueOf(windowUnitString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

