/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.util.ParserKeywordValidatorUtil;
import io.confluent.ksql.util.ParserUtil;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;

public class SyntaxErrorValidator
extends BaseErrorListener {
    private static final Pattern EXTRANEOUS_INPUT_PATTERN = Pattern.compile("extraneous input.*expecting.*");
    private static final Pattern MISMATCHED_INPUT_PATTERN = Pattern.compile("mismatched input.*expecting.*");
    private static final Map<Class<?>, BiFunction<String, RecognitionException, Boolean>> ERROR_VALIDATORS = ImmutableMap.of(SqlBaseParser.VariableNameContext.class, SyntaxErrorValidator::isValidVariableName);

    private static boolean isValidVariableName(String errorMessage, RecognitionException exception) {
        if (MISMATCHED_INPUT_PATTERN.matcher(errorMessage).matches() && exception.getOffendingToken() != null) {
            return ParserKeywordValidatorUtil.getKsqlReservedWords().contains(exception.getOffendingToken().getText());
        }
        return false;
    }

    private static boolean validateErrorContext(RuleContext context, String errorMessage, RecognitionException exception) {
        BiFunction<String, RecognitionException, Boolean> validator = ERROR_VALIDATORS.get(context.getClass());
        if (validator == null) {
            return false;
        }
        return validator.apply(errorMessage, exception);
    }

    private static boolean shouldIgnoreSyntaxError(String errorMessage, RecognitionException exception) {
        if (exception.getCtx() != null) {
            return SyntaxErrorValidator.validateErrorContext(exception.getCtx(), errorMessage, exception);
        }
        return false;
    }

    private static boolean isKeywordError(String message, String offendingSymbol) {
        Matcher m = EXTRANEOUS_INPUT_PATTERN.matcher(message);
        return m.find() && ParserUtil.isReserved(offendingSymbol);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        if (e != null && SyntaxErrorValidator.shouldIgnoreSyntaxError(message, e)) {
            return;
        }
        if (offendingSymbol instanceof Token && SyntaxErrorValidator.isKeywordError(message, ((Token)offendingSymbol).getText())) {
            String tokenName = ((Token)offendingSymbol).getText();
            String newMessage = "\"" + tokenName + "\" is a reserved keyword and it can't be used as an identifier. You can use it as an identifier by escaping it as '" + tokenName + "' ";
            throw new ParsingException(newMessage, e, line, charPositionInLine);
        }
        throw new ParsingException(message, e, line, charPositionInLine);
    }
}

