/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.SqlBaseBaseVisitor;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.util.ParserUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.text.StringSubstitutor;

public final class VariableSubstitutor {
    private static final Pattern VALID_IDENTIFIER_NAMES = Pattern.compile("[A-Za-z_][A-Za-z0-9_@]*");
    public static final String PREFIX = "${";
    public static final String SUFFIX = "}";

    private VariableSubstitutor() {
    }

    public static String substitute(KsqlParser.ParsedStatement parsedStatement, Map<String, String> valueMap) {
        String statementText = parsedStatement.getStatementText();
        SqlSubstitutorVisitor visitor = new SqlSubstitutorVisitor(statementText, valueMap);
        return visitor.replace(parsedStatement.getStatement());
    }

    private static final class SqlSubstitutorVisitor
    extends SqlBaseBaseVisitor<Void> {
        private final String statementText;
        private final Map<String, String> valueMap;
        private Map<String, String> sanitizedValueMap;

        SqlSubstitutorVisitor(String statementText, Map<String, String> valueMap) {
            this.statementText = Objects.requireNonNull(statementText, "statementText");
            this.valueMap = Objects.requireNonNull(valueMap, "valueMap");
            this.sanitizedValueMap = new HashMap<String, String>(valueMap.size());
        }

        public String replace(SqlBaseParser.SingleStatementContext singleStatementContext) {
            this.visit((ParseTree)singleStatementContext);
            return StringSubstitutor.replace((Object)this.statementText, this.sanitizedValueMap);
        }

        private void lookupVariables(String text) {
            for (String variableName : VariablesLookup.lookup(text)) {
                if (!this.valueMap.containsKey(variableName)) continue;
                this.sanitizedValueMap.putIfAbsent(variableName, ParserUtil.sanitize(this.valueMap.get(variableName)));
            }
        }

        @Override
        public Void visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
            String text = ParserUtil.unquote(context.getText(), "'");
            this.lookupVariables(text);
            return null;
        }

        @Override
        public Void visitVariableLiteral(SqlBaseParser.VariableLiteralContext context) {
            String variableRef = context.getText();
            String variableName = SqlSubstitutorVisitor.unwrap(variableRef);
            String variableValue = this.valueMap.getOrDefault(variableName, variableRef);
            this.throwIfInvalidLiteral(variableValue, ParserUtil.getLocation(context));
            this.sanitizedValueMap.putIfAbsent(variableName, ParserUtil.sanitize(variableValue));
            return null;
        }

        @Override
        public Void visitVariableValue(SqlBaseParser.VariableValueContext context) {
            String text = ParserUtil.unquote(context.getText(), "'");
            this.lookupVariables(text);
            return null;
        }

        @Override
        public Void visitVariableIdentifier(SqlBaseParser.VariableIdentifierContext context) {
            String variableRef = context.getText();
            String variableName = SqlSubstitutorVisitor.unwrap(variableRef);
            String variableValue = this.valueMap.getOrDefault(variableName, variableRef);
            this.throwIfInvalidIdentifier(variableValue, ParserUtil.getLocation(context));
            this.sanitizedValueMap.putIfAbsent(variableName, variableValue);
            return null;
        }

        private String getIdentifierText(String value) {
            char firstChar = value.charAt(0);
            char lastChar = value.charAt(value.length() - 1);
            if (firstChar == '\"' && lastChar == '\"') {
                return ParserUtil.unquote(value, "\"");
            }
            if (firstChar == '`' && lastChar == '`') {
                return ParserUtil.unquote(value, "`");
            }
            return value;
        }

        static String unwrap(String value) {
            return value.substring(VariableSubstitutor.PREFIX.length(), value.length() - VariableSubstitutor.SUFFIX.length());
        }

        private void throwIfInvalidIdentifier(String value, Optional<NodeLocation> location) {
            String identifierText = this.getIdentifierText(value);
            if (!VALID_IDENTIFIER_NAMES.matcher(identifierText).matches()) {
                throw new ParseFailedException("Illegal argument at " + location.map(NodeLocation::toString).orElse("?") + ". Identifier names cannot start with '@' and may only contain alphanumeric values and '_'. Got: '" + value + "'", this.statementText);
            }
        }

        private void throwIfInvalidLiteral(String value, Optional<NodeLocation> location) {
            if (ParserUtil.isQuoted(value, "'")) {
                return;
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                return;
            }
            if (this.isNumber(value)) {
                return;
            }
            throw new ParseFailedException("Illegal argument at " + location.map(NodeLocation::toString).orElse("?") + ". Got: '" + value + "'", this.statementText);
        }

        private boolean isNumber(String value) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    double d = Double.parseDouble(value);
                    if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
                try {
                    new BigDecimal(value);
                    return true;
                }
                catch (NumberFormatException numberFormatException3) {
                    return false;
                }
            }
        }
    }

    static class VariablesLookup {
        VariablesLookup() {
        }

        public static Set<String> lookup(String text) {
            HashSet<String> variables = new HashSet<String>();
            StringSubstitutor substr = new StringSubstitutor(key -> {
                variables.add(key);
                return null;
            });
            substr.setVariablePrefix(VariableSubstitutor.PREFIX);
            substr.setVariableSuffix(VariableSubstitutor.SUFFIX);
            substr.replace(text);
            return variables;
        }
    }
}

