/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import java.util.Optional;

@Immutable
public class CreateTable
extends CreateSource
implements ExecutableDdlStatement {
    public CreateTable(SourceName name, TableElements elements, boolean orReplace, boolean notExists, CreateSourceProperties properties) {
        this(Optional.empty(), name, elements, orReplace, notExists, properties);
    }

    public CreateTable(Optional<NodeLocation> location, SourceName name, TableElements elements, boolean orReplace, boolean notExists, CreateSourceProperties properties) {
        super(location, name, elements, orReplace, notExists, properties);
        CreateTable.throwOnNonPrimaryKeys(elements);
    }

    @Override
    public CreateSource copyWith(TableElements elements, CreateSourceProperties properties) {
        return new CreateTable(this.getLocation(), this.getName(), elements, this.isOrReplace(), this.isNotExists(), properties);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("elements", (Object)this.getElements()).add("orReplace", this.isOrReplace()).add("notExists", this.isNotExists()).add("properties", (Object)this.getProperties()).toString();
    }

    private static void throwOnNonPrimaryKeys(TableElements elements) {
        Optional<TableElement> wrongKey = elements.stream().filter(e -> e.getNamespace().isKey() && e.getNamespace() != TableElement.Namespace.PRIMARY_KEY).findFirst();
        wrongKey.ifPresent(col -> {
            String loc = NodeLocation.asPrefix((Optional)col.getLocation());
            throw new ParseFailedException(loc + "Column " + col.getName() + " is a 'KEY' column: please use 'PRIMARY KEY' for tables." + System.lineSeparator() + "Tables have PRIMARY KEYs, which are unique and NON NULL." + System.lineSeparator() + "Streams have KEYs, which have no uniqueness or NON NULL constraints.");
        });
    }
}

