/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Explain
extends Statement {
    private final Optional<Statement> statement;
    private final Optional<String> queryId;

    public Explain(Optional<String> queryId, Optional<Statement> statement) {
        this(Optional.empty(), queryId, statement);
    }

    public Explain(Optional<NodeLocation> location, Optional<String> queryId, Optional<Statement> statement) {
        super(location);
        this.statement = Objects.requireNonNull(statement, "statement");
        this.queryId = queryId;
        if (statement.isPresent() == queryId.isPresent()) {
            throw new IllegalArgumentException("Must supply either queryId or statement");
        }
    }

    public Optional<Statement> getStatement() {
        return this.statement;
    }

    public Optional<String> getQueryId() {
        return this.queryId;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.queryId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)((Object)obj);
        return Objects.equals(this.statement, o.statement) && Objects.equals(this.queryId, o.queryId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("statement", this.statement).add("queryId", this.queryId).toString();
    }
}

