/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Immutable
public class InsertValues
extends Statement {
    private final SourceName target;
    private final ImmutableList<ColumnName> columns;
    private final ImmutableList<Expression> values;

    public InsertValues(SourceName target, List<ColumnName> columns, List<Expression> values) {
        this(Optional.empty(), target, columns, values);
    }

    public InsertValues(Optional<NodeLocation> location, SourceName target, List<ColumnName> columns, List<Expression> values) {
        super(location);
        this.target = Objects.requireNonNull(target, "target");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values"));
        if (values.isEmpty()) {
            throw new KsqlException("Expected some values for INSERT INTO statement.");
        }
        if (!columns.isEmpty() && columns.size() != values.size()) {
            throw new KsqlException("Expected number columns and values to match: " + columns.stream().map(Name::text).collect(Collectors.toList()) + ", " + values);
        }
    }

    public SourceName getTarget() {
        return this.target;
    }

    public List<ColumnName> getColumns() {
        return this.columns;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsertValues(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InsertValues that = (InsertValues)((Object)o);
        return Objects.equals(this.target, that.target) && Objects.equals(this.columns, that.columns) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.columns, this.values);
    }

    public String toString() {
        return "InsertValues{target=" + this.target + ", columns=" + this.columns + ", values=" + this.values + '}';
    }
}

