/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.Relation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Join
extends Relation {
    private final Relation left;
    private final ImmutableList<JoinedSource> rights;

    public Join(Relation left, List<JoinedSource> rights) {
        this(Optional.empty(), left, rights);
    }

    public Join(Optional<NodeLocation> location, Relation left, List<JoinedSource> rights) {
        super(location);
        this.left = Objects.requireNonNull(left, "left");
        this.rights = ImmutableList.copyOf((Collection)Objects.requireNonNull(rights, "sources"));
        Preconditions.checkArgument((!rights.isEmpty() ? 1 : 0) != 0, (Object)"Cannot join without any right sources!");
    }

    public Relation getLeft() {
        return this.left;
    }

    public ImmutableList<JoinedSource> getRights() {
        return this.rights;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    public String toString() {
        return "Join{left=" + (Object)((Object)this.left) + ", rights=" + this.rights + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Join that = (Join)((Object)o);
        return Objects.equals((Object)this.left, (Object)that.left) && Objects.equals(this.rights, that.rights);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.rights});
    }
}

