/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class PartitionBy
extends AstNode {
    private final ImmutableList<Expression> partitionByExpressions;

    public PartitionBy(Optional<NodeLocation> location, List<Expression> partitionByExpressions) {
        super(location);
        this.partitionByExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionByExpressions, "partitionByExpressions"));
        if (partitionByExpressions.isEmpty()) {
            throw new KsqlException("PARTITION BY requires at least one expression");
        }
        HashSet partitionBys = new HashSet(partitionByExpressions.size());
        partitionByExpressions.forEach(exp -> {
            if (!partitionBys.add(exp)) {
                throw new KsqlException("Duplicate PARTITION BY expression: " + exp);
            }
        });
    }

    public List<Expression> getExpressions() {
        return this.partitionByExpressions;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPartitionBy(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PartitionBy partitionBy = (PartitionBy)((Object)o);
        return Objects.equals(this.partitionByExpressions, partitionBy.partitionByExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.partitionByExpressions);
    }

    public String toString() {
        return "PartitionBy{partitionByExpressions=" + this.partitionByExpressions + '}';
    }
}

