/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.query.QueryId;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TerminateQuery
extends Statement {
    public static final String ALL_QUERIES = "ALL";
    private final Optional<QueryId> queryId;

    public static TerminateQuery all(Optional<NodeLocation> location) {
        return new TerminateQuery(location, Optional.empty());
    }

    public static TerminateQuery query(Optional<NodeLocation> location, QueryId queryId) {
        return new TerminateQuery(location, Optional.of(queryId));
    }

    private TerminateQuery(Optional<NodeLocation> location, Optional<QueryId> queryId) {
        super(location);
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public Optional<QueryId> getQueryId() {
        return this.queryId;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTerminateQuery(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TerminateQuery that = (TerminateQuery)((Object)o);
        return Objects.equals(this.queryId, that.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId);
    }

    public String toString() {
        return "TerminateQuery{queryId=" + this.queryId + '}';
    }
}

