/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.kstream.JoinWindows;

@Immutable
public class WithinExpression
extends AstNode {
    private final long before;
    private final long after;
    private final TimeUnit beforeTimeUnit;
    private final TimeUnit afterTimeUnit;
    private final JoinWindows joinWindows;

    public WithinExpression(long size, TimeUnit timeUnit) {
        this(size, size, timeUnit, timeUnit);
    }

    public WithinExpression(long before, long after, TimeUnit beforeTimeUnit, TimeUnit afterTimeUnit) {
        this(Optional.empty(), before, after, beforeTimeUnit, afterTimeUnit);
    }

    public WithinExpression(Optional<NodeLocation> location, long before, long after, TimeUnit beforeTimeUnit, TimeUnit afterTimeUnit) {
        super(location);
        this.before = before;
        this.after = after;
        this.beforeTimeUnit = Objects.requireNonNull(beforeTimeUnit, "beforeTimeUnit");
        this.afterTimeUnit = Objects.requireNonNull(afterTimeUnit, "afterTimeUnit");
        this.joinWindows = this.createJoinWindows();
    }

    public JoinWindows joinWindow() {
        return this.joinWindows;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithinExpression(this, context);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" WITHIN ");
        if (this.before == this.after) {
            builder.append(this.before).append(' ').append((Object)this.beforeTimeUnit);
        } else {
            builder.append('(').append(this.before).append(' ').append((Object)this.beforeTimeUnit).append(", ").append(this.after).append(' ').append((Object)this.afterTimeUnit).append(")");
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.before, this.after, this.beforeTimeUnit, this.afterTimeUnit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WithinExpression withinExpression = (WithinExpression)((Object)o);
        return this.before == withinExpression.before && this.after == withinExpression.after && Objects.equals((Object)this.beforeTimeUnit, (Object)withinExpression.beforeTimeUnit) && Objects.equals((Object)this.afterTimeUnit, (Object)withinExpression.afterTimeUnit);
    }

    private JoinWindows createJoinWindows() {
        JoinWindows joinWindow = JoinWindows.of((Duration)Duration.ofMillis(this.beforeTimeUnit.toMillis(this.before)));
        return joinWindow.after(Duration.ofMillis(this.afterTimeUnit.toMillis(this.after)));
    }

    public long getBefore() {
        return this.before;
    }

    public long getAfter() {
        return this.after;
    }

    public TimeUnit getBeforeTimeUnit() {
        return this.beforeTimeUnit;
    }

    public TimeUnit getAfterTimeUnit() {
        return this.afterTimeUnit;
    }
}

