/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlPrimitiveType;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.ParserUtil;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public final class SqlTypeParser {
    private final TypeRegistry typeRegistry;

    public static SqlTypeParser create(TypeRegistry typeRegistry) {
        return new SqlTypeParser(typeRegistry);
    }

    private SqlTypeParser(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry");
    }

    public Type parse(String schema) {
        SqlBaseParser.TypeContext typeContext = SqlTypeParser.parseTypeContext(schema);
        return this.getType(typeContext);
    }

    public Type getType(SqlBaseParser.TypeContext type) {
        Optional<NodeLocation> location = ParserUtil.getLocation(type);
        SqlType sqlType = this.getSqlType(type);
        return new Type(location, sqlType);
    }

    private SqlType getSqlType(SqlBaseParser.TypeContext type) {
        if (type.baseType() != null) {
            String baseType = SqlTypeParser.baseTypeToString(type.baseType());
            if (SqlPrimitiveType.isPrimitiveTypeName((String)baseType)) {
                return SqlPrimitiveType.of((String)baseType);
            }
            return (SqlType)this.typeRegistry.resolveType(baseType).orElseThrow(() -> new KsqlException("Cannot resolve unknown type: " + baseType));
        }
        if (type.DECIMAL() != null) {
            return SqlDecimal.of((int)ParserUtil.processIntegerNumber(type.number(0), "DECIMAL(PRECISION)"), (int)ParserUtil.processIntegerNumber(type.number(1), "DECIMAL(SCALE)"));
        }
        if (type.ARRAY() != null) {
            return SqlArray.of((SqlType)this.getSqlType(type.type(0)));
        }
        if (type.MAP() != null) {
            return SqlMap.of((SqlType)this.getSqlType(type.type(0)), (SqlType)this.getSqlType(type.type(1)));
        }
        if (type.STRUCT() != null) {
            SqlStruct.Builder builder = SqlStruct.builder();
            for (int i = 0; i < type.identifier().size(); ++i) {
                String fieldName = ParserUtil.getIdentifierText(type.identifier(i));
                SqlType fieldType = this.getSqlType(type.type(i));
                builder.field(fieldName, fieldType);
            }
            return builder.build();
        }
        throw new IllegalArgumentException("Unsupported type specification: " + type.getText());
    }

    private static SqlBaseParser.TypeContext parseTypeContext(String schema) {
        SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)schema)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        SqlBaseParser parser = new SqlBaseParser((TokenStream)tokenStream);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
        return parser.type();
    }

    private static String baseTypeToString(SqlBaseParser.BaseTypeContext baseType) {
        if (baseType.identifier() != null) {
            return ParserUtil.getIdentifierText(baseType.identifier());
        }
        throw new KsqlException("Base type must contain either identifier, time with time zone, or timestamp with time zone");
    }
}

