/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.properties.with;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.properties.with.PropertiesConfig;
import io.confluent.ksql.properties.with.InsertIntoConfigs;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class InsertIntoProperties {
    private final PropertiesConfig props;

    public static InsertIntoProperties none() {
        return new InsertIntoProperties(Collections.emptyMap());
    }

    public static InsertIntoProperties from(Map<String, Literal> literals) {
        return new InsertIntoProperties(literals);
    }

    private InsertIntoProperties(Map<String, Literal> originals) {
        this.props = new PropertiesConfig(InsertIntoConfigs.CONFIG_METADATA, originals);
    }

    public Optional<String> getQueryId() {
        return Optional.ofNullable(this.props.getString("QUERY_ID")).map(String::toUpperCase);
    }

    public String toString() {
        return this.props.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertIntoProperties that = (InsertIntoProperties)o;
        return Objects.equals((Object)this.props, (Object)that.props);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.props});
    }
}

