/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import java.util.Optional;

@Immutable
public class CreateStream
extends CreateSource
implements ExecutableDdlStatement {
    public CreateStream(SourceName name, TableElements elements, boolean orReplace, boolean notExists, CreateSourceProperties properties, boolean isSource) {
        this(Optional.empty(), name, elements, orReplace, notExists, properties, isSource);
    }

    public CreateStream(Optional<NodeLocation> location, SourceName name, TableElements elements, boolean orReplace, boolean notExists, CreateSourceProperties properties, boolean isSource) {
        super(location, name, elements, orReplace, notExists, properties, isSource);
        CreateStream.throwOnPrimaryKeys(elements);
    }

    @Override
    public CreateSource.SourceType getSourceType() {
        return CreateSource.SourceType.STREAM;
    }

    @Override
    public CreateSource copyWith(TableElements elements, CreateSourceProperties properties) {
        return new CreateStream(this.getLocation(), this.getName(), elements, this.isOrReplace(), this.isNotExists(), properties, this.isSource());
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateStream(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("elements", (Object)this.getElements()).add("orReplace", this.isOrReplace()).add("notExists", this.isNotExists()).add("properties", (Object)this.getProperties()).add("isSource", this.isSource()).toString();
    }

    private static void throwOnPrimaryKeys(TableElements elements) {
        Optional<TableElement> wrongKey = elements.stream().filter(e -> e.getConstraints().isPrimaryKey()).findFirst();
        wrongKey.ifPresent(col -> {
            String loc = NodeLocation.asPrefix((Optional)col.getLocation());
            throw new ParseFailedException(loc + "Column " + col.getName() + " is a 'PRIMARY KEY' column: please use 'KEY' for streams." + System.lineSeparator() + "Tables have PRIMARY KEYs, which are unique and NON NULL." + System.lineSeparator() + "Streams have KEYs, which have no uniqueness or NON NULL constraints.");
        });
    }
}

