/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.SelectItem;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SingleColumn
extends SelectItem {
    private final Optional<ColumnName> alias;
    private final Expression expression;

    public SingleColumn(Expression expression, Optional<ColumnName> alias) {
        this(Optional.empty(), expression, alias);
    }

    public SingleColumn(Optional<NodeLocation> location, Expression expression, Optional<ColumnName> alias) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression");
        this.alias = Objects.requireNonNull(alias, "alias");
    }

    public SingleColumn copyWithExpression(Expression expression) {
        return new SingleColumn(this.getLocation(), expression, this.alias);
    }

    public Optional<ColumnName> getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)((Object)obj);
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    public String toString() {
        return "SingleColumn{, alias=" + this.alias + ", expression=" + this.expression + '}';
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }
}

