/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Statements
extends AstNode {
    private final ImmutableList<Statement> statements;

    public Statements(Optional<NodeLocation> location, List<Statement> statements) {
        super(location);
        this.statements = ImmutableList.copyOf((Collection)Objects.requireNonNull(statements, "statements"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="statements is ImmutableList")
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitStatements(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("statements", this.statements).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Statements o = (Statements)((Object)obj);
        return Objects.equals(this.statements, o.statements);
    }

    public int hashCode() {
        return Objects.hash(this.statements);
    }
}

