/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Relation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Table
extends Relation {
    private final SourceName name;

    public Table(SourceName name) {
        this(Optional.empty(), name);
    }

    public Table(Optional<NodeLocation> location, SourceName name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
    }

    public SourceName getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)((Object)o);
        return Objects.equals(this.name, table.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

